module.exports = {
    DATA_VERSION: "2.1",
    METADATA_VERSION: "2.2",

    ENTITY_WIDTH: 7,

    // Amp Types
    AMP_TYPES: ["LINUSCON", "LINUS10", "LINUS5C", "LINUS10C", "LINUS14", "LINUS12C", "LINUS8"],
    /*, "LINUS4" */

    // Amp Sn Nr Id
    AMP_SN_NR_ID: {
        "1": "LINUS10",
        "2": "LINUSCON",
        "3": "LINUS14",
        "5": "LINUS5C",
        "6": "LINUS10C",
        "7": "LINUS8",
        "8": "LINUS4",
        "9": "LINUS12C",
        "?": "LINUS8"
    },

    // Firmware Version
    // new l10c version FW_VERSION: 62, shipping version FW_VERSION: 61,
    // new l10c version FW_DATE: 0x29042019, shipping version FW_DATE: 0x08022019,
    FW_VERSION: 70, // 69 // 68, // 66 // 64, last beta version out 15122020
    FW_VERSION_MIN: 21,
    FW_DATE: 0x14092022, // 0x05072022, // 0x18052021, // 0x11032021, // 0x15122020,

    // Speaker Libversion
    SPEAKER_LIB: "SpeakerLib 1.2.8",
    SPEAKER_DATE: 0x20210803,

    // macs 1W George, 3W Hansi
    // rest clients
    CHECK_FOR_MAC: false,
    MACS: [
        "14:10:9f:d5:be:61",
        "C8-5B-76-E9-42-FE" // This one is windows – all CAPITALS in the O.S.
    ],

    // Online Status
    ONLINE_STATUS_ONLINE: "online",
    ONLINE_STATUS_OFFLINE: "offline",
    ONLINE_STATUS_STORING_DATA: "storingdata",
    ONLINE_STATUS_CONNECTION_LOST: "connectionlost",
    ONLINE_STATUS_CONNECTION_BROKEN: "connectionbroken",
    ONLINE_STATUS_RECONNECTED: "reconnected",
    ONLINE_STATUS_SYNC_DATA: "syncdata",
    ONLINE_STATUS_LIB_ERROR: "liberror",
    ONLINE_STATUS_FW_ERROR: "fwerror",

    // Power Status
    POWER_STATUS_ON: "on",
    POWER_STATUS_OFF: "off",
    POWER_STATUS_STANDBY: "standby",
    POWER_STATUS_POWER_UP: "powerup",

    // Group Constants
    MAXIMUM_GROUPS_IN_CHANNEL: 10,
    MAXIMUM_HUMAN: 12,
    MAXIMUM_HFSHELF: 12,
    MINIMUM_HUMAN: -12,
    MINIMUM_HFSHELF: -12,
    MAXIMUM_DELAY_C_TYPE: 200,
    MAXIMUM_DELAY: 1000,
    MAXIMUM_GAIN: 12,
    MINIMUM_GAIN: -96,
    MAX_EQS: 7,

    // Speaker
    DEFAULT_SPEAKER_NR: 117,

    // Graph Constants
    SPECTRALLINES: 180, // spectreal lines

    // AES Receiver
    AES_RECEIVER_MODE_PRO: 1,
    AES_RECEIVER_MODE_CONSUMER: 2,
    AES_RECEIVER_INPUT_LINET_1_2: 0,
    AES_RECEIVER_INPUT_LINET_3_4: 1,
    AES_RECEIVER_INPUT_LINET_5_6: 2,
    AES_RECEIVER_INPUT_LINET_7_8: 3,
    AES_RECEIVER_INPUT_DANTE: 100,

    // UI DEV Flag
    UIDEV: false,
    UIDEV_INPUT_SIGNALS: false,

    // preset
    SLOT_SPEAKER_OFFSET: 31,
    SLOT_LIVE_SPEAKER_CH0: 22,
    LIVE_PRESET: 21,
    SLOT_FIRST_FREE_10C: 82,
    SLOT_FIRST_FREE_5C: 76,
    SLOT_MAX_C: 130,
    SLOT_FIRST_FREE: 122,
    SLOT_MAX: 170,

    // File extension
    FILE_EXTENSION: "linuscontrol",
    AUTOSAVE_OUTDATED_PERIOD: 1000 * 60 * 60 * 24 * 3, // 3 Days

    // HW Lock
    HWLOCK_MASTER_PASSWORD: "mz2A5HRR",

    // Routing
    ROUTING_DEFAULT_FALLBACK_SENSE: 800,

    // Amp State page size
    AMP_STATE_MAX_INDEX: 126,
    AMP_STATE_PAGE_SIZE: 1024,

    // Evac Settings
    EVAC_MONITOR_INTERVAL: 0,
    EVAC_MONITOR_MEASUREMENT_DELAY: 0,

    // UI Config
    UI_CONFIG: {
        eqToggle: false,
        // can trum off speaker eq's
        commandDialog: false,
        // my test dialog
        stateManagement: true,
        evacDialog: true,
        loadStatus: true
        // only if payed extra for linus14 and linus12C?
    }
}